// priority: 100
onEvent("recipes", (event) => {
    //Constants
    const minecraftLogs = [
        'minecraft:oak_log',
        'minecraft:spruce_log',
        'minecraft:birch_log',
        'minecraft:jungle_log',
        'minecraft:acacia_log',
        'minecraft:dark_oak_log',
        'minecraft:stripped_oak_log',
        'minecraft:stripped_spruce_log',
        'minecraft:stripped_birch_log',
        'minecraft:stripped_jungle_log',
        'minecraft:stripped_acacia_log',
        'minecraft:stripped_dark_oak_log'
    ]

    const bopTConstructMalumLogs = [
        'biomesoplenty:fir_log',
        'biomesoplenty:stripped_fir_log',
        'biomesoplenty:redwood_log',
        'biomesoplenty:stripped_redwood_log',
        'biomesoplenty:cherry_log',
        'biomesoplenty:stripped_cherry_log',
        'biomesoplenty:mahogany_log',
        'biomesoplenty:stripped_mahogany_log',
        'biomesoplenty:jacaranda_log',
        'biomesoplenty:stripped_jacaranda_log',
        'biomesoplenty:palm_log',
        'biomesoplenty:stripped_palm_log',
        'biomesoplenty:willow_log',
        'biomesoplenty:stripped_willow_log',
        'biomesoplenty:dead_log',
        'biomesoplenty:stripped_dead_log',
        'biomesoplenty:magic_log',
        'biomesoplenty:stripped_magic_log',
        'biomesoplenty:umbran_log',
        'biomesoplenty:stripped_umbran_log',
        'biomesoplenty:hellbark_log',
        'biomesoplenty:stripped_hellbark_log',
        'tconstruct:stripped_greenheart_log',
        'tconstruct:greenheart_log',
        'tconstruct:stripped_skyroot_log',
        'tconstruct:skyroot_log',
        'tconstruct:stripped_bloodshroom_log',
        'tconstruct:bloodshroom_log',
        'malum:runewood_log',
        'malum:stripped_runewood_log',
        'malum:exposed_runewood_log',
        'malum:revealed_runewood_log',
        'malum:soulwood_log',
        'malum:stripped_soulwood_log',
        'malum:exposed_soulwood_log',
        'malum:revealed_soulwood_log'
    ]

    const quarkLogs = [
        'quark:azalea_log',
        'quark:stripped_azalea_log',
        'quark:blossom_log',
        'quark:stripped_blossom_log',
    ]

    //All planks but vanilla and quark
    const moddedPlanks = [
        'biomesoplenty:fir_planks',
        'biomesoplenty:redwood_planks',
        'biomesoplenty:cherry_planks',
        'biomesoplenty:mahogany_planks',
        'biomesoplenty:jacaranda_planks',
        'biomesoplenty:palm_planks',
        'biomesoplenty:willow_planks',
        'biomesoplenty:dead_planks',
        'biomesoplenty:magic_planks',
        'biomesoplenty:umbran_planks',
        'biomesoplenty:hellbark_planks',
        'tconstruct:greenheart_planks',
        'tconstruct:skyroot_planks',
        'tconstruct:bloodshroom_planks',
        'malum:runewood_planks',
        'malum:soulwood_planks',
        'soul_ice:red_planks',
        'soul_ice:yellow_planks',
        'soul_ice:orange_planks',
        'soul_ice:blue_planks',
        'soul_ice:light_blue_planks',
        'soul_ice:cyan_planks',
        'soul_ice:green_planks',
        'soul_ice:lime_planks',
        'soul_ice:purple_planks',
        'soul_ice:pink_planks',
        'soul_ice:magenta_planks',
        'soul_ice:brown_planks',
        'soul_ice:white_planks',
        'soul_ice:light_gray_planks',
        'soul_ice:gray_planks',
        'soul_ice:black_planks',
        'botania:livingwood_planks',
        'botania:mossy_livingwood_planks',
        'botania:framed_livingwood',
        'botania:pattern_framed_livingwood',
        'botania:dreamwood_planks',
        'botania:mossy_dreamwood_planks',
        'botania:framed_dreamwood',
        'botania:pattern_framed_dreamwood',
        'botania:shimmerwood_planks'
    ];


    //Quartz uncrafting, because you can convert the block back into quartz using Tinkers.
    //But then you can't "recraft" it into a different colored quartz, or mana quartz. This fixes that with an
    //uncrafting recipe.
    //After all, it is a #forge:storage_blocks, just like metal blocks.
    event.shapeless('4x minecraft:quartz', ['minecraft:quartz_block']);

    //In the same manner, clay block to clay ball
    event.shapeless('4x minecraft:clay_ball', ['minecraft:clay']);

    //Rooted blocks. Bonemealing the rooted blocks gives you hanging roots, just craft it back with the materials
    event.shapeless('biomesoplenty:rooted_sand', ['minecraft:sand', 'minecraft:hanging_roots']);
    event.shapeless('minecraft:rooted_dirt', ['minecraft:dirt', 'minecraft:hanging_roots']);

    //Any planks that aren't Quark planks go into vanilla chest recipe
    event.shaped("minecraft:chest", ["PPP", "P P", "PPP"], {
        P: moddedPlanks
    });

    //Sandstone fix
    event.shaped('6x minecraft:sandstone_slab', ['SSS', '   ', '   '], {
        S: 'minecraft:sandstone'
    }).id('minecraft:sandstone_slab')
    event.shaped('minecraft:red_sandstone_slab', ['SSS', '   ', '   '], {
        S: 'minecraft:red_sandstone'
    }).id('minecraft:red_sandstone_slab')

    //Hopper from barrel
    event.shaped('minecraft:hopper', ['I I', 'IBI', ' I '], {
        I: 'minecraft:iron_ingot',
        B: 'minecraft:barrel'
    })

    //Saddle
    event.shaped('minecraft:saddle', ['LLL', 'L L', 'N N'], {
        L: 'minecraft:leather',
        N: 'minecraft:iron_nugget'
    })

    //Horse armors
    event.shaped('minecraft:iron_horse_armor', ['M M', 'MMM', 'M M'], {
        M: 'minecraft:iron_ingot'
    })
    event.shaped('minecraft:golden_horse_armor', ['M M', 'MMM', 'M M'], {
        M: 'minecraft:gold_ingot'
    })
    event.shaped('minecraft:diamond_horse_armor', ['M M', 'MMM', 'M M'], {
        M: 'minecraft:diamond'
    })

    //Logs recipes

    //To stick (we filter the logs because otherwise Botania logs will have a recipe conflict with its wood)
    event.shaped('16x minecraft:stick', ['L ', 'L '], { L: minecraftLogs })
    event.shaped('16x minecraft:stick', ['L ', 'L '], { L: bopTConstructMalumLogs })
    event.shaped('16x minecraft:stick', ['L ', 'L '], { L: quarkLogs })
    event.shaped('16x minecraft:stick', ['L ', 'L '], { L: '#forge:logs/archwood' })

    //To chest: BoP, Ars Nouveau, TConstruct, Malum.
    event.shaped('4x minecraft:chest', ['LLL', 'L L', 'LLL'], { L: bopTConstructMalumLogs })
    event.shaped('4x ars_nouveau:archwood_chest', ['LLL', 'LGL', 'LLL'], { L: '#forge:logs/archwood', G: 'minecraft:gold_ingot' })

    //Ladder recipe
    event.shaped('4x minecraft:ladder', ['S S', 'SPS', 'S S'], {
        S: '#forge:rods/wooden',
        P: moddedPlanks
    })

    //Sticky Piston
    event.shaped('minecraft:sticky_piston', ['S', 'P'], {
        S: '#forge:slimeballs',
        P: 'minecraft:piston'
    }).id('minecraft:sticky_piston')

    //Repeater
    event.shaped('minecraft:repeater', ['R R', 'SRS', 'TTT'], {
        R: '#forge:dusts/redstone',
        S: '#forge:rods/wooden',
        T: '#forge:stone'
    }).id('quark:tweaks/crafting/utility/misc/repeater')
    event.shaped('minecraft:repeater', ['TRT', 'SSS', '   '], {
        S: '#forge:stone',
        T: 'minecraft:redstone_torch',
        R: '#forge:dusts/redstone'
    }).id('minecraft:repeater')

    //Piston
    event.shaped('minecraft:piston', ['PPP', 'CIC', 'CRC'], {
        P: '#minecraft:planks',
        C: ['minecraft:cobblestone', 'minecraft:cobbled_deepslate', 'minecraft:blackstone'],
        I: '#forge:ingots/iron',
        R: '#forge:dusts/redstone'
    }).id('minecraft:piston')
});

